/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.export.VWExportImportTreePanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class VWExportImportTree
extends JTree
implements KeyListener {
    private VWConfigBaseNode m_focus = null;
    private TreePath m_activeDragPath = null;

    public VWExportImportTree(VWConfigBaseNode root, VWExportImportTreePanel treePanel) {
        super(root);
        this.m_focus = root;
        this.addKeyListener(this);
        this.getAccessibleContext().getAccessibleSelection().addAccessibleSelection(0);
        VWAccessibilityHelper.setAccessibility(this, treePanel, VWResource.ConfigurationTree, VWResource.ConfigurationTreeDescription);
    }

    protected void refresh() {
        this.revalidate();
        this.repaint();
        this.updateUI();
        this.setSelectionPath(new TreePath(this.m_focus.getPath()));
    }

    protected void setFocus(VWConfigBaseNode node) {
        this.m_focus = node;
        if (this.m_focus != null) {
            this.getAccessibleContext().setAccessibleName(this.m_focus.getName());
            this.getAccessibleContext().setAccessibleDescription(this.m_focus.getName());
            FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            this.requestFocus();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 32: {
                if (this.m_focus == null) break;
                switch (this.m_focus.getExportOptSelection()) {
                    case 0: {
                        this.m_focus.updateExportSelection(2);
                        break;
                    }
                    case 2: {
                        this.m_focus.updateExportSelection(0);
                        break;
                    }
                    case 1: {
                        this.m_focus.updateExportSelection(2);
                    }
                }
                this.revalidate();
                this.repaint();
                this.updateUI();
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }
}

